import React from "react";
import { I18nManager, StyleSheet, View } from "react-native";
import Animated, {
    interpolate,
    Extrapolate,
    useAnimatedStyle,
    interpolateColor,
} from "react-native-reanimated";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

const Pagination = ({ data, x, size }) => {
    return (
        <View style={styles.paginationContainer}>
            {data?.map((_, i) => {
                const animatedDotStyle = useAnimatedStyle(() => {
                    const widthAnimation = interpolate(
                        x.value,
                        [(i - 1) * size, i * size, (i + 1) * size],
                        [8, 8, 8],
                        Extrapolate.CLAMP
                    );
                    const backgroundColor = interpolateColor(
                        x.value,
                        [(i - 1) * size, i * size, (i + 1) * size],
                        ["rgba(137, 137, 137, 0.35)", "#FCCA19", "rgba(137, 137, 137, 0.35)"]
                    )
                    return {
                        width: widthAnimation,
                        backgroundColor: backgroundColor,
                    };
                });
                return (
                    <Animated.View
                        style={[styles.dots, animatedDotStyle]}
                        key={i}
                    />
                );
            })}
        </View>
    );
};

export default Pagination;

const styles = StyleSheet.create({
    paginationContainer: {
        height: 40,
        alignItems: "center",
        flexDirection: "row",
        justifyContent: "center",
    },
    dots: {
        height: dpr(8),
        borderRadius: 50,
        marginHorizontal: 3,
        backgroundColor: "#FCCA19",
    },
});
